nuc_master = read.csv('~/data/nuc_master.csv')
nuc_master_sub = subset(nuc_master,cac_c40 > quantile(nuc_master$cac_c40,0.25) & wt_c40 > quantile(nuc_master$wt_c40,0.25) )
#plot supple4A
png(file = '~/data/figure/supple4A_ATI_coor.png', width = 1.9, height = 2.5, units = "in", res = 300, bg = "white", type = "cairo-png" )
ggplot(nuc_master_sub, aes(x=wt_ATI, y=cac_ATI) ) +
  geom_bin2d(bins=100) +xlab('WT')+ylab(expression(paste(italic(cac1),Delta)))+ylim(1.2,1.9)+xlim(1.2,1.9)+
  theme_bw()+theme(panel.grid.major = element_blank(),
                        panel.grid.minor = element_blank(),
                        panel.background = element_rect(colour = "black", size=0.3),
                        axis.text  = element_text(size=8,face='bold'),
                        axis.title = element_text(size=8),
                        legend.text=element_text(size=5),
                        legend.key.size = unit(0.1, 'in'),
                        legend.position = 'bottom')+scale_fill_continuous(name='')
dev.off()

cor(nuc_master_sub$wt_ATI,nuc_master_sub$cac_ATI) 
#r < 2.2 x 10 -16


#wt orderd by cac ATI
nuc_chrIV = nuc_chrIV[order(nuc_chrIV$cac_ATI,decreasing = FALSE),]
wt_nuc_norm = nuc_chrIV[,3:7]/nuc_chrIV[,7]
wt_nuc_norm[wt_nuc_norm >=1.5]=1.499
a=wt_nuc_norm

#plot heatmap supple4B
scr.m = matrix(c(0.04, 0.51, 0.3, 0.95, #WT heatmap
                 0.04 ,0.51, 0.25,0.3 #heatmap legend
                 
                 
),
ncol = 4, byrow = T
)

file.name <- "/datafinal/supple4B_wt_ATIbycac.png"
png(file = file.name, width = 7, height = 18, units = "in", res = 300, bg = "white", type = "cairo-png" )
par(cex=1.5)

close.screen(all.screens = T)

split.screen(scr.m)

par(oma = c(0, 1, 0, 1)) # make room (i.e. the 4's) for the overall x and y axis titles

a=wt_nuc_norm
screen(1)
par(mar = c(1.5,0.5,1.2,0.5), cex=2.5, cex.main=0.8)
dens_dot_plot(a[nrow(a):1,],  z_min = -0.5, z_max =1.5, plot_title='WT',x_axt='n',y_axt = "n",lowCol = 'red', medCol = "white", highCol = "blue", numColors = 100) #adjust z range for each experiment
axis(side=1,labels=F, tick=F,at=c(-2,-1,0,1,2)) #x-axis
mtext(at=c(-2,-1,0,1,2), text=c('P','C10','C15','C20','C40'), side=1, line=0, cex=1.2)

screen(2)
eff_color2 <- matrix(c(0,0.2,0.4,0.6,0.8,0.9999), nrow=1, ncol=6)
par(mar = c(1,1,1,1))
dens_dot_plot(eff_color2, z_min = -0.5, z_max = 1.5, plot_title="",x_axt='n',y_axt = "n",medCol='white',lowCol = "red", highCol = 'blue',numColors = 100)
mtext(at=c(-2.5,-1.5,-0.5,0.5,1.5,2.5), text=c(0,0.2,0.4,0.6,0.8,1), side=1,cex=1.2)

close.screen(all.screens = T)

dev.off()


#plot supple4C plot
scr.m = matrix(c(0.1, 0.5, 0.80, 0.95,
                 0.1, 0.5, 0.65, 0.80,
                 0.1, 0.5, 0.50, 0.65,
                 0.1, 0.5, 0.35, 0.50,
                 0.1, 0.5, 0.2, 0.35, #fast nuc stackup 
                 
                 0.5, 0.9, 0.80, 0.95,
                 0.5, 0.9, 0.65, 0.80,
                 0.5, 0.9, 0.50, 0.65,
                 0.5, 0.9, 0.35, 0.50,
                 0.5, 0.9, 0.20, 0.35, #slow nuc stackup
                 
                 0.51, 0.82, 0.08, 0.13 #legend
                 
                 
                 
                 
),
ncol = 4, byrow = T
)

wt_fast_mtx_list_bycac = readRDS('~/data/wt_fast_mtx_list_cacFastSlow.RDS')
wt_slow_mtx_list_bycac = readRDS('~/data/wt_slow_mtx_list_cacFastSlow.RDS')
file.name <- "/data/supple4C_wt_stackByCac.png"
png(file = file.name, width = 11, height = 15, units = "in", res = 250, bg = "white", type = "cairo-png" )
par(cex=1.5)

close.screen(all.screens = T)

split.screen(scr.m)

par(oma = c(0, 3, 0, 0)) # make room (i.e. the 4's) for the overall x and y axis titles

for (f in 1:4) {
  screen(f)
  par(mar = c(0.5,0.5,0.5,0.5), cex=1, cex.main=0.7) 
  a = wt_fast_mtx_list_bycac[[f]][30:230,100:500]
  dens_dot_plot(a[nrow(a):1,],  z_min = 0, z_max =900, plot_title='',x_axt = 'n', y_axt = 'n',lowCol = 'slateblue2', medCol = "yellow", highCol = "red", numColors = 50) #adjust z range for each experiment
  axis(side = 2,labels = F, tick = T, at = c(20,70,120,170))
  mtext(at=c(20,70,120,170), text=c(50,100,150,200), side=2, line=0.8, cex=1.5)
  
}


for (f in 6:9) {
  screen(f)
  par(mar = c(0.5,0.5,0.5,0.5), cex=1, cex.main=0.7) 
  a = wt_slow_mtx_list_bycac[[f-5]][30:230,100:500]
  dens_dot_plot(a[nrow(a):1,],  z_min = 0, z_max =900, plot_title='',x_axt = 'n', y_axt = 'n',lowCol = 'slateblue2', medCol = "yellow", highCol = "red", numColors = 50) #adjust z range for each experiment
}

screen(5)
par(mar = c(0.5,0.5,0.5,0.5), cex=1, cex.main=0.7) 
a = wt_fast_mtx_list_bycac[[5]][30:230,100:500]
dens_dot_plot(a[nrow(a):1,],  z_min = 0, z_max =900, plot_title='',x_axt = 'n', y_axt = 'n',lowCol = 'slateblue2', medCol = "yellow", highCol = "red", numColors = 50) #adjust z range for each experiment
axis(side = 2,labels = F, tick = T, at = c(20,70,120,170))
mtext(at=c(20,70,120,170), text=c(50,100,150,200), side=2, line=0.8, cex=1.5)
axis(side=1,labels=F, tick=T,at=c(-150,0,150)) #x-axis
mtext(at=c(-150,0,150), text=c(-150,0,150), side=1, line=0.8, cex=1.5)

screen(10)
par(mar = c(0.5,0.5,0.5,0.5), cex=0.8, cex.main=0.7) 
a = wt_slow_mtx_list_bycac[[5]][30:230,100:500]
dens_dot_plot(a[nrow(a):1,],  z_min = 0, z_max =900, plot_title='',x_axt = 'n', y_axt = 'n',lowCol = 'slateblue2', medCol = "yellow", highCol = "red", numColors = 50) #adjust z range for each experiment
axis(side=1,labels=F, tick=T,at=c(-150,0,150)) #x-axis
mtext(at=c(-150,0,150), text=c(-150,0,150), side=1, line=0.8, cex=1.5)


mtext('Fragment length (bp)', side = 2, outer = TRUE, cex=2.2, line=-1.1,at = 0.6)
mtext('Distance from nucleosome dyad (bp)', side = 1, outer = T, cex=2.2,line=-7.5,at = 0.5)


screen(11)
eff_color2 <- matrix(c(0,100,200,300,400,500,600,700,800,900), nrow=1, ncol=10)
par(mar = c(0.8,0,0.8,0))
dens_dot_plot(eff_color2, z_min = 0, z_max = 900, plot_title="",lowCol='slateblue2',x_axt='n',y_axt = "n",medCol = "yellow", highCol = 'red',numColors = 50)
mtext(at=c(-3.5,-1.5,0.5,2.5,4.5), text=c(100,300,500,700,900), side=1,cex=1.5)

close.screen(all.screens = T)

dev.off()

